package com.payful.example.utils;

import cn.hutool.core.util.ObjUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.digest.MD5;
import cn.hutool.log.Log;
import cn.hutool.log.LogFactory;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;

public final class SignUtil {
    private static final Log log = LogFactory.get();

    public static TreeMap<String, String> convertBeanToMap(Object bean) {
        TreeMap<String, String> map = new TreeMap<>();
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(bean.getClass());
            PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
            for (PropertyDescriptor pd : propertyDescriptors) {
                String propertyName = pd.getName();
                if (!"class".equals(propertyName) && !"sign".equals(propertyName)) {
                    Method readMethod = pd.getReadMethod();
                    Object propertyValue = readMethod.invoke(bean);
                    map.put(propertyName, ObjUtil.defaultIfNull(propertyValue, StrUtil.EMPTY).toString());
                }
            }
        } catch (Exception e) {
            log.error("Bean 转MAP 异常", e);
        }
        return map;
    }

    /**
     * TreeMa集合2String
     *
     * @param data TreeMa
     * @return String
     */
    public static String coverMap2String(Map<String, String> data) {
        StringBuilder sf = new StringBuilder();
        for (String key : data.keySet()) {
            if (StrUtil.isNotBlank(data.get(key))) {
                sf.append(key).append("=").append(data.get(key).trim()).append("&");
            }
        }
        return sf.substring(0, sf.length() - 1);
    }

    /**
     * TreeMa集合2String
     *
     * @param data TreeMa
     * @return String
     */
    public static String coverMapObj2String(Map<String, Object> data) {
        StringBuilder sf = new StringBuilder();
        for (String key : data.keySet()) {
            if (Objects.nonNull(data.get(key)) && StrUtil.isNotBlank(data.get(key).toString())) {
                sf.append(key).append("=").append(data.get(key).toString().trim()).append("&");
            }
        }
        return sf.substring(0, sf.length() - 1);
    }

    /**
     * 签名
     * @param paramStr
     * @param key
     * @return
     * @throws Exception
     */
    public static String sign(String paramStr, String key){
        return MD5.create().digestHex(new StringBuilder(paramStr).append("&").append("key").append("=").append(key).toString()).toUpperCase();
    }

    /**
     * 签名
     * @param data
     * @param key
     * @return
     * @throws Exception
     */
    public static String sign(Map<String, Object> data, String key){
        String originValue = coverMapObj2String(data) + "&" + "key" + "=" + key;
        System.out.println("签名字符串为：" + originValue);
        return MD5.create().digestHex(originValue).toUpperCase();
    }

}