package com.payful.example.utils;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import cn.hutool.log.Log;
import cn.hutool.log.LogFactory;
import com.payful.example.common.Constant;

import java.util.Map;

public class ApiUtil {
    private static final Log log = LogFactory.get();

    public static String post(String url, Map<String, String> headers, String body) {
        log.info("Prepare the request message(url:[" + url + "])):" + body);
        HttpRequest httpRequest = HttpUtil.
                createPost(url).
                headerMap(headers, Boolean.TRUE).
                body(body).
                setConnectionTimeout(Constant.CONNECTION_TIMEOUT).
                setReadTimeout(Constant.READ_TIMEOUT);

        String rsp = httpRequest.execute().body();
        log.info("Receive the return message(url:[" + url + "])):" + rsp);
        return rsp;
    }
}
