package com.payful.example.query.balance;

import cn.hutool.core.lang.UUID;
import cn.hutool.json.JSONUtil;
import com.payful.example.common.Constant;
import com.payful.example.enums.CountryEnum;
import com.payful.example.utils.ApiUtil;
import com.payful.example.utils.SignUtil;
import com.payful.util.PayfulSignUtil;

import java.util.Map;
import java.util.TreeMap;

/**
 * @Description: 查询余额
 * @Date: 2025/06/26 15:29
 * @Author: jinlai
 */
public class SearchBalanceDemo {
    public static void main(String[] args) {
        // 不同国家需要替换成对应国家配置
        Map<String, Object> params = new TreeMap<>();
        params.put("countryId", CountryEnum.MEX.getId());// 国家
        params.put("merId", Constant.MEX_GAME_MERCHANTID); // 商户id
        params.put("nonceStr", UUID.fastUUID().toString(true));

        // 生成签名参考一
        System.out.println(PayfulSignUtil.createSign(params, Constant.MEX_GAME_MERCHANTKEY));
        // 生成签名参考二
        System.out.println(SignUtil.sign(params, Constant.MEX_GAME_MERCHANTKEY));

        //商户key
        params.put("sign", SignUtil.sign(params, Constant.MEX_GAME_MERCHANTKEY));
        String resp = ApiUtil.post(Constant.SEARCH_BALANCE_URL, Constant.defaultHeads, JSONUtil.toJsonStr(params));
        System.out.println(resp);
    }
}
