package com.payful.example.payout.mex.spei;

import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.UUID;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.json.JSONUtil;
import com.payful.example.common.Constant;
import com.payful.example.enums.CountryEnum;
import com.payful.example.enums.CurrencyEnum;
import com.payful.example.utils.ApiUtil;
import com.payful.example.utils.SignUtil;
import com.payful.util.PayfulSignUtil;

import java.util.Map;
import java.util.TreeMap;

/**
 * @Description: 墨西哥Spei代付Demo
 * @Date: 2025/06/26 15:29
 * @Author: jinlai
 */
public class MexSpeiPayOutDemo {
    public static void main(String[] args) {
        Map<String, Object> params = new TreeMap<>();
        params.put("account", "646150996402711110");
        params.put("bankId", "40138");
        params.put("callbackUrl", "https://test.com");
        params.put("countryId", CountryEnum.MEX.getId());  // 墨西哥国家代码
        params.put("currency", CurrencyEnum.MXN.getId());   // 墨西哥比索
        params.put("customerName", "Test Name");
        params.put("description", "1");
        params.put("merId", Constant.MEX_SPEI_MERCHANTID);
        params.put("merOrderNo", DateUtil.format(DateUtil.date(), DatePattern.PURE_DATETIME_MS_PATTERN) + RandomUtil.randomNumbers(8));
        params.put("nonceStr", UUID.fastUUID().toString(true));
        params.put("orderAmount", "100.00");
        params.put("payProduct", "15");   // 银行转账支付产品

        // 生成签名参考一
        System.out.println(PayfulSignUtil.createSign(params, Constant.MEX_SPEI_MERCHANTKEY));
        // 生成签名参考二
        System.out.println(SignUtil.sign(params, Constant.MEX_SPEI_MERCHANTKEY));

        params.put("sign", SignUtil.sign(params, Constant.MEX_SPEI_MERCHANTKEY));
        String resp = ApiUtil.post(Constant.PAY_OUT_URL, Constant.defaultHeads, JSONUtil.toJsonStr(params));
        System.out.println(resp);
    }
}
