package com.payful.example.payin.mex.spei;

import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.UUID;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.json.JSONUtil;
import com.payful.example.common.Constant;
import com.payful.example.enums.CountryEnum;
import com.payful.example.enums.CurrencyEnum;
import com.payful.example.utils.ApiUtil;
import com.payful.example.utils.SignUtil;
import com.payful.util.PayfulSignUtil;

import java.util.Map;
import java.util.TreeMap;

/**
 * @Description: 墨西哥Card代收Demo
 * @Date: 2025/06/26 15:29
 * @Author: jinlai
 */
public class MexPayInDemo {
    public static void main(String[] args) {
        Map<String, Object> params = new TreeMap<>();
        params.put("callbackUrl", "https://test.com");
        params.put("countryId",CountryEnum.MEX.getId());  // 墨西哥国家代码
        params.put("currency", CurrencyEnum.MXN.getId());   // 墨西哥比索
        params.put("maxOrderAmount", "15000.00");
        params.put("merId", Constant.MEX_SPEI_MERCHANTID);
        params.put("merOrderNo", DateUtil.format(DateUtil.date(), DatePattern.PURE_DATETIME_MS_PATTERN)+ RandomUtil.randomNumbers(8));
        params.put("minOrderAmount", "10.00");
        params.put("nonceStr", UUID.fastUUID().toString(true));
        params.put("orderAmount", "30");
        params.put("payProduct", "15");   // 支付产品类型 15
        params.put("repeat", true);       // 重复支付标志

        // 生成签名参考一
        System.out.println(PayfulSignUtil.createSign(params, Constant.MEX_SPEI_MERCHANTKEY));
        // 生成签名参考二
        System.out.println(SignUtil.sign(params, Constant.MEX_SPEI_MERCHANTKEY));

        params.put("sign", SignUtil.sign(params, Constant.MEX_SPEI_MERCHANTKEY));
        String resp = ApiUtil.post(Constant.PAY_IN_URL, Constant.defaultHeads, JSONUtil.toJsonStr(params));
        System.out.println(resp);
    }
}
