package com.payful.example.payin.mex.cash;

import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.UUID;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSONObject;
import com.payful.example.common.Constant;
import com.payful.example.enums.CountryEnum;
import com.payful.example.enums.CurrencyEnum;
import com.payful.example.utils.ApiUtil;
import com.payful.example.utils.SignUtil;
import com.payful.util.PayfulSignUtil;

import java.util.Map;
import java.util.TreeMap;

/**
 * @Description: 墨西哥Card代收Demo
 * @Date: 2025/06/26 15:29
 * @Author: jinlai
 */
public class MexPayInDemo {
    public static void main(String[] args) {
        Map<String, Object> params = new TreeMap<>();
        params.put("countryId", CountryEnum.MEX.getId());  // 墨西哥国家代码
        params.put("orderAmount", 20);   // 金额为20 MXN
        params.put("payProduct", "03");  // 支付产品类型 03
        params.put("merId", Constant.MEX_CASH_MERCHANTID);
        params.put("expireTimeL", 259200); // 到期时间（秒）
        params.put("description", "transas12121dasdasda");
        params.put("merOrderNo", DateUtil.format(DateUtil.date(), DatePattern.PURE_DATETIME_MS_PATTERN) + RandomUtil.randomNumbers(8));

        // 构建嵌套的requestData对象 （
        // 历史原因不推荐使用 hutool JSONObject 如要使用请求保持和demo 顺序一至，不然组装的签名字符串会不一至）
        JSONObject requestData = new JSONObject();
        JSONObject businessUnit = new JSONObject();
        businessUnit.put("name", "12");
        businessUnit.put("key", "111");
        requestData.put("businessUnit", businessUnit);
        requestData.put("showHtmlFlag", "1");
        params.put("requestData", requestData);

        params.put("customerEmail", "21312312312@qq.com");
        params.put("currency", CurrencyEnum.MXN.getId());   // 墨西哥比索
        params.put("appName", "payful");
        params.put("nonceStr", UUID.fastUUID().toString(true));
        params.put("callbackUrl", "http://test.com");


        // 生成签名参考一
        System.out.println(PayfulSignUtil.createSign(params, Constant.MEX_CASH_MERCHANTKEY));
        // 生成签名参考二
        System.out.println(SignUtil.sign(params, Constant.MEX_CASH_MERCHANTKEY));

        params.put("sign", SignUtil.sign(params, Constant.MEX_CASH_MERCHANTKEY));
        String resp = ApiUtil.post(Constant.PAY_IN_URL, Constant.defaultHeads, JSONUtil.toJsonStr(params));
        System.out.println(resp);
    }
}
