package com.payful.example.payin.mex.card;

import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.UUID;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.json.JSONUtil;
import com.payful.example.common.Constant;
import com.payful.example.enums.CountryEnum;
import com.payful.example.enums.CurrencyEnum;
import com.payful.example.utils.ApiUtil;
import com.payful.example.utils.SignUtil;
import com.payful.util.PayfulSignUtil;

import java.util.Map;
import java.util.TreeMap;

/**
 * @Description: 墨西哥Card代收Demo
 * @Date: 2025/06/26 15:29
 * @Author: jinlai
 */
public class MexPayInDemo {
    public static void main(String[] args) {
        Map<String, Object> params = new TreeMap<>();
        params.put("callbackUrl", "https://test.com");
        params.put("checkOut", true);  // 墨西哥特定参数
        params.put("countryId",CountryEnum.MEX.getId());  // 墨西哥国家代码
        params.put("currency", CurrencyEnum.MXN.getId());   // 墨西哥比索
        params.put("merId", Constant.MEX_MALL_MERCHANTID);
        params.put("merOrderNo", DateUtil.format(DateUtil.date(), DatePattern.PURE_DATETIME_MS_PATTERN)+ RandomUtil.randomNumbers(8));
        params.put("nonceStr", UUID.fastUUID().toString(true));
        params.put("orderAmount", "200");
        params.put("payProduct", "18");   // 支付产品类型 18
        params.put("returnUrl", "https://www.bing.com/");
        params.put("productName", "testName");
        params.put("productQuantity", 10);
        params.put("email", "test@123.com");
        params.put("receiverAddressMain", "Sample street 357");
        params.put("receiverAddressExtra", "Apt 2");
        params.put("receiverCity", "Example city");
        params.put("receiverProvince", "Example state");
        params.put("receiverCountry", "MXN");
        params.put("receiverZipCode", "01254");
        params.put("receiverPhone", "1234567890");
        params.put("alias", "test alias");
        params.put("newUser", false);
        params.put("hasDispute", true);
        params.put("hasRefund", false);
        params.put("hasSingedLong", true);
        params.put("customerName", "Aaliyah Rogers");
        params.put("description", "payful");

        // 生成签名参考一
        System.out.println(PayfulSignUtil.createSign(params, Constant.MEX_MALL_MERCHANTKEY));
        // 生成签名参考二
        System.out.println(SignUtil.sign(params, Constant.MEX_MALL_MERCHANTKEY));

        params.put("sign", SignUtil.sign(params, Constant.MEX_MALL_MERCHANTKEY));
        String resp = ApiUtil.post(Constant.PAY_IN_URL, Constant.defaultHeads, JSONUtil.toJsonStr(params));
        System.out.println(resp);
    }
}
