package com.payful.example.payin.bra;

import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.UUID;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.json.JSONUtil;
import com.payful.example.common.Constant;
import com.payful.example.enums.CountryEnum;
import com.payful.example.enums.CurrencyEnum;
import com.payful.example.utils.ApiUtil;
import com.payful.example.utils.SignUtil;
import com.payful.util.PayfulSignUtil;

import java.util.Map;
import java.util.TreeMap;

/**
 * @Description: 巴西代收Demo
 * @Date: 2025/06/26 15:29
 * @Author: jinlai
 */
public class BraPayInDemo {
    public static void main(String[] args) {
        Map<String, Object> params = new TreeMap<>();
        params.put("callbackUrl", "https://test.com");
        params.put("countryId", CountryEnum.BRA.getId());
        params.put("currency", CurrencyEnum.BRL.getId());
        params.put("customerEmail", "9064@outlook.com");
        params.put("customerIdentification", "123456789-09");
        params.put("customerName", "test name");
        params.put("description", "test description");
        params.put("merId", Constant.BRA_MERCHANTID);
        params.put("merOrderNo", DateUtil.format(DateUtil.date(), DatePattern.PURE_DATETIME_MS_PATTERN)+ RandomUtil.randomNumbers(8));
        params.put("nonceStr", UUID.fastUUID().toString(true));
        params.put("orderAmount", "10.00");
        params.put("payProduct", "24");
        // 生成签名方式
        // 生成签名参考一 需要引入  payful-sign-1.0.0.jar  payfulDemo/lib/payful-sign-1.0.0.jar
        System.out.println(PayfulSignUtil.createSign(params,Constant.BRA_MERCHANTKEY));
        // 生成签名参考二
        System.out.println(SignUtil.sign(params, Constant.BRA_MERCHANTKEY));
        params.put("sign", SignUtil.sign(params, Constant.BRA_MERCHANTKEY));
        String resp = ApiUtil.post(Constant.PAY_IN_URL, Constant.defaultHeads, JSONUtil.toJsonStr(params));
        System.out.println(resp);
    }
}
