package com.payful.example.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 枚举类:响应状态码
 */
@Getter
@AllArgsConstructor
public enum ResultCodeEnum {
    SUCCESS("200", "success ", "成功"),
    SUCCESS201("201", "Data does not exist ", "数据不存在"),
    SUCCESS202("202", "The data is not a unique key ", "数据不是唯一键"),
    ERROR("500", "service error ", "失败"),
    PAY_PRODUCT_PARAM_ERROR("400","payProduct cannot be empty","支付产品不可为空"),
    ERROR501("501", "The merchant does not exist ", "商户不存在"),
    ERROR502("502", "The merchant has been disabled ", "商户已禁用"),
    ERROR503("503", "Intelligent routing exception ", "智能路由异常"),
    ERROR504("504", "Exception in getting account and channel ", "获取账户和渠道异常"),
    ERROR505("505", "The minimum amount is lower than the handling fee ", "区间最低金额对应的手续费小于区间最低金额"),
    ERROR506("506", "The amount is lower than the handling fee", "手续费小于订单金额（固定金额）"),
    ERROR507("507", "Risk control/Limitation issues ", "风险管控/限额问题"),
    ERROR508("508", "Service Exception ", "修改未结算金额异常"),
    ERROR509("509", "Service Exception ", "插入代收订单异常"),
    ERROR510("510", "Service Exception ", "插入代收订单详情异常"),
    ERROR511("511", "Service Exception ", "插入付款参考异常"),
    ERROR512("512", "Service Exception ", "冻结资金异常"),
    ERROR513("513", "Service Exception ", "插入代付订单异常"),
    ERROR514("514", "Service Exception ", "插入代付订单详情异常"),
    ERROR515("515", "Merchant key not set ", "商户密钥未设置"),
    ERROR516("516", "Signature verification failed ", "签名验证失败"),
    ERROR517("517", "El enlace de pago ha caducado, por favor vuelva a generarlo. ", "收银台代收订单已过期"),
    ERROR518("518", "Callback address not configured and callback address not provided. ", "未配置且未传入回调地址"),
    ERROR519("519", "The frozen amount is incorrect. ", "冻结金额错误"),
    ERROR520("520", "The frozen account does not exist. ", "冻结账户不存在"),
    ERROR521("521", "Insufficient available balance in the account, failed to freeze. ", "账户可用金额不足,冻结失败"),
    ERROR522("522", "The account with sufficient balance and enabled status does not exist. ",
            "不存在余额充足且状态启用的账户"),
    ERROR523("523", "There is no channel that supports this payment product and has an enabled status. ",
            "不存在支持此支付产品且状态启用的渠道"),
    ERROR524("524", "The matching channel has insufficient balance or an abnormal account status. ",
            "匹配渠道余额不足或账户状态异常"),
    ERROR525("525", "There is no enabled route for the payment product. ", "不存在已启用路由的支付产品"),
    ERROR526("526", "The matching channel does not have the route enabled. ", "匹配渠道未启用路由"),
    ERROR527("527", "The matching account for payin/payout is frozen. ", "匹配账户代收/代付被冻结"),
    ERROR528("528", "Order status changed", "订单状态已修改"),
    ERROR529("529", "Service Exception ", "插入支付提交记录异常"),
    ERROR530("530", "The callback address provided or configured is an illegal URL. ", "传入或配置的回调地址为非法URL"),
    ERROR531("531", "Merchant order number duplicate. ", "商户订单号重复"),
    ERROR532("532", "Range 300-2592000, minimum transition time 300 seconds. ", "范围300-2592000，最小过渡时间300秒"),
    ERROR533("533", "The minimum amount collected: 10 reals (BRL), the maximum amount: 20,000 reals (BRL). ", "代收最低金额：10 雷亚尔(BRL)，最高：20000 雷亚尔(BRL)"),
    ERROR534("534", "The minimum amount collected: 3000 (COP), the maximum amount: 2000000 (COP). ", "代收最低金额：3000 (COP)，最高：2000000 (COP)"),
    ERROR535("535", "channel get token exception", "渠道获取token数据异常"),
    ERROR536("536", "get channel bankList error", "获取渠道银行列表失败"),
    ERROR537("537", "The amount must be between 3000 and 2000000", "金额范围在3000-2000000之间"),
    ERROR538("538", "channel server error", "渠道服务异常"),
    ERROR539("539", "The minimum amount collected: 3000 (COP), the maximum amount: 3000000 (COP). ", "代收最低金额：3000 (COP)，最高：3000000 (COP)"),
    ERROR540("540", "The minimum amount collected: 10000 (COP), the maximum amount: 3000000 (COP). ", "代收最低金额：10000 (COP)，最高：3000000 (COP)"),
    PARAM_ERROR("400", "param error ", "参数错误"),
    PARAM_NOT_NULL_ERROR("400", "param cannot be empty ", "参数错误"),
    ERROR600("600", "Please try again later. ", "队列满载服务熔断"),
    ERROR700("700", "channel erro.", "渠道调用异常"),
    ERROR701("701", "CustomerIdentification have reached the maximum usage limit for the day.", "身份证明文件已经达到当日使用上限"),
    ERROR702("702", "This channel does not support this CustomerIdentificationType.", "该渠道不支持此身份证明文件类型"),
    ERROR703("703", "[orderAmount] does not comply with the rule.", "orderAmount不符合规则"),
    ERROR541("541", "IP whitelist not configured. Please contact PayFul operations for configuration!", "IP白名单不能为空!"),
    ERROR542("542", "This IP is not in the whitelist of the merchant configuration", "该IP 不在商户配置的白名单中"),
    ERROR543("543", "Failed to resolve the request body", "请求体解析失败"),
    ERROR544("544", "System configuration error", "系统配置错误"),
    ERROR101("101","Pay Product is error","支付方式错误"),
    ERROR102("102","Pay Order Fail","下单失败"),
    ERROR103("103","Payment in progress, please try again later","正在支付中，请稍后再试"),
    ERROR104("104","Pay Order No Error","支付单号错误"),
    ERROR105("105","The order amount is less than the handling fee","订单金额小于手续费"),
    ERROR545("545", "Se desconoce el error del sistema, Póngase en contacto con la Operación para verificar la causa específica.", "系统未知错误，请联系运营核实具体原因"),
    ERROR546("546", "Canal desconocido error, Póngase en contacto con la Operación para verificar la causa específica.", "渠道未知错误，请联系运营核实具体原因"),
    ERROR547("547", "El sistema es anormal, Póngase en contacto con la Operación para verificar las razones específicas.", "系统异常，请联系运营核实具体原因"),
    ERROR548("548", "The order number is duplicated and the order placement failed", "订单号重复，下单失败");

    private final String code;
    private final String msg;
    private final String msgCn;

}
